// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

// I borrow code from Avisynth here

#ifndef __RESIZERS__
#define __RESIZERS__

#include "MVInterface.h"
#include <math.h>

class ResamplingFunction {
public:
  virtual double f(double x) = 0;
  virtual int support() = 0;
};

class PointResampling : public ResamplingFunction { // - added by Fizick in v0.9.10
public:
  double f(double x);  
  int support() { return 1; } // simulate PointResampling via bilinear framework
};

class BilinearResampling : public ResamplingFunction {
public:
  double f(double x);  
  int support() { return 1; }
};

class BicubicResampling : public ResamplingFunction 
{
  double p0, p2 ,p3 ,q0 ,q1 ,q2 ,q3;

public:
  BicubicResampling(double b, double c);
  double f(double x);
  int support() { return 2; }
};

class LanczosResampling : public ResamplingFunction
{
public:
	double f(double x);
	int support() { return 3; };

private:
	double sinc(double value);
};




class Upsizer {
	unsigned char **destination;
	int width;
	int height;
	int **widthCoefficients;
	int **heightCoefficients;
	int widthRatio;
	int heightRatio;
	int widthLength;
	int widthHalfLength;
	int heightLength;
	int heightHalfLength;
	int intScale;
	int logScale;
	int xOrigin;
	int yOrigin;
	int xOffset;
	int yOffset;

	ResamplingFunction *resamplingFunction;
	inline unsigned char FitIntoUCOff(int x, int off) { 
		int rep = x >> off;
		return ( rep < 0 ) ? 0 : ( rep > 255 ) ? 255 : rep;
	}
	inline unsigned char FitIntoUCDiv(int x, int div) { 
		int rep = x / div;
		return ( rep < 0 ) ? 0 : ( rep > 255 ) ? 255 : rep;
	}
public :
	Upsizer(int w, int h, int wr, int hr, int ua, int uo, 
			int offx, int offy, ResamplingFunction *rf);
	~Upsizer();
	void BuildCoefficients();
	void Resize(const unsigned char *src, unsigned char **dest,int sp, int dp, bool doo);
};

#endif