#include "SWCopyCode.h"



SWCopy::SWCopy(int nWidth, int nHeight)
{
   Assembler x86;

   x86.push(eax);
   x86.push(ebx);
   x86.push(ecx);
   x86.push(edx);
   x86.push(esi);
   x86.push(edi);
   x86.push(ebp);

   // fetch parameters
   x86.mov(edi, dword_ptr [&par_dst]);
   x86.mov(esi, dword_ptr [&par_src]);
   x86.mov(edx, dword_ptr [&par_dstp]);
   x86.mov(ecx, dword_ptr [&par_srcp]);

   for ( int j = 0; j < nHeight; j += 2 ) // assumes nHeight even
   {
      int i = 0;
      for ( ; i + 16 <= nWidth; i += 16 )
      {
         x86.movq(mm0, qword_ptr[esi+i]);
         x86.movq(mm1, qword_ptr[esi+i+8]);
         x86.movq(mm2, qword_ptr[esi+ecx+i]);
         x86.movq(mm3, qword_ptr[esi+ecx+i+8]);

         x86.movq(qword_ptr[edi+i], mm0);
         x86.movq(qword_ptr[edi+i+8], mm1);
         x86.movq(qword_ptr[edi+edx+i], mm2);
         x86.movq(qword_ptr[edi+edx+i+8], mm3);
      }
      if ( i + 8 <= nWidth )
      {
         x86.movq(mm0, qword_ptr[esi+i]);
         x86.movq(mm2, qword_ptr[esi+ecx+i]);

         x86.movq(qword_ptr[edi+i], mm0);
         x86.movq(qword_ptr[edi+edx+i], mm2);

         i += 8;
      }
      if ( i + 4 <= nWidth )
      {
         x86.mov(eax ,dword_ptr[esi+i]);
         x86.mov(dword_ptr[edi+i], eax);

         x86.mov(eax ,dword_ptr[esi+ecx+i]);
         x86.mov(dword_ptr[edi+edx+i], eax);

         i += 4;
      }
      if ( i + 2 <= nWidth )
      {
         x86.mov(ax ,word_ptr[esi+i]);
         x86.mov(word_ptr[edi+i], ax);

         x86.mov(ax ,word_ptr[esi+ecx+i]);
         x86.mov(word_ptr[edi+edx+i], ax);
      } // assume nWidth even
      x86.lea(edi, dword_ptr[edi + 2 * edx]);
      x86.lea(esi, dword_ptr[esi + 2 * ecx]);
   }

   x86.pop(ebp);
   x86.pop(edi);
   x86.pop(esi);
   x86.pop(edx);
   x86.pop(ecx);
   x86.pop(ebx);
   x86.pop(eax);
   x86.ret();

   assembler = DynamicAssembledCode(x86);

}

SWCopy::~SWCopy()
{
   assembler.Free();
}