#include "SoftWireHelper.h"

DynamicAssembledCode::DynamicAssembledCode(Assembler &x86) {
  entry = 0;
  const char* soft_err = "";
  try {
    entry = (void(*)())x86.callable();
  } catch (Error _err) { soft_err = _err.getString(); }
  if(!entry)
  {
    _RPT0(0,"SoftWire Compilation error:");
    _RPT0(0,soft_err);
    _RPT0(0,"\n");
  }
  ret = (BYTE*)x86.acquire();
}
  
void DynamicAssembledCode::Free() {
  if (ret) free(ret);
}



