#include "Stats.h"
#include <math.h>

Stats::Stats()
{
	size = 6000;
	index = 0;
	array = new double[size];
	raz();
	currsum = 0;
	currsum2 = 0;
	previndex = 0;
	previndex2 = 0;
}

Stats::Stats(int s)
{
	size = s;
	index = 0;
	array = new double[size];
	raz();
	currsum = 0;
	currsum2 = 0;
	previndex = 0;
	previndex2 = 0;
}

void Stats::raz()
{
	for ( int i = 0; i < size; i++ )
		array[i] = 0;
}

Stats::Stats(int s, double *a)
{
	size = s;
	array = new double[size];
	for ( int i = 0; i < size; i++ )
		array[i] = a[i];

	currsum = 0;
	currsum2 = 0;
	index = size;
	previndex = 0;
	previndex2 = 0;
}

Stats::~Stats()
{	
	delete[] array;
}

void Stats::lengthen(int n)
{
	int i;
	double *temp = new double[size+n];
	for ( i = 0 ; i < size; i++)
		temp[i] = array[i];
	
	delete[] array;
	array = temp;
	size += n;
}

void Stats::push(double e)
{	
	if ( index >= size ) lengthen(6000);
	array[index] = e;
	index++;
}

void Stats::put(int i, double e)
{	
	if ( i >= size ) lengthen(i+100-size);
	array[i] = e;
	if ( i >= index ) index = i + 1;
}

double Stats::count()
{	return index; }

void Stats::reset()
{
	index = 0;
	currsum = 0;
	currsum2 = 0;
	previndex = 0;
	previndex2 = 0;
	raz();
}

double Stats::length()
{	
	return size;
}

double Stats::bid()
{
	double sum = 0;
	for ( int i = 0; i < index; i++ )
		sum += array[i];
	return sum;
}


double Stats::sum()
{
	/*double sum = currsum;
	for ( int i = previndex; i < index; i++ )
		sum += array[i];
	currsum = sum;
	previndex = index;*/
	double sum = 0;
	for ( int i = 0; i < index; i++ )
		sum += array[i];
	return sum;
}


double Stats::mean()
{
	return (sum()) / index;
}

double Stats::mse()
{
	/*double sum2 = currsum2;
	for ( int i = previndex2; i < index; i++ )
		sum2 += array[i] * array[i];

	currsum2 = sum2;
	previndex2 = index;*/
	double sum2 = 0;
	for ( int i = 0; i < index; i++ )
		sum2 += array[i] * array[i];

	double sum1 = sum() / index;

	return (sum2 / index - sum1 * sum1);
}

double Stats::std()
{	
	return sqrt(mse());
}

double Stats::minima()
{
	double mini = array[0];
	for ( int i = 0; i < index; i++ )
		mini = minimum(mini,array[i]);

	return mini;
}

double Stats::maxima()
{
	double maxi = array[0];
	for ( int i = 0; i < index; i++ )
		maxi = maximum(maxi,array[i]);

	return maxi;
}

double Stats::minimum(double l, double r)
{	
	return ( l < r ) ? l : r;
}

double Stats::maximum(double l, double r)
{	
	return ( l < r ) ? r : l;
}

void Stats::wtof(FILE * file, Stats * s1, Stats * s2 )
{
	for ( int i = 0; i < s1->index; i++ )
		fprintf(file,"%f;%f\n",s1->array[i],s2->array[i]);
}

void Stats::wtof(FILE * file, Stats * s1, Stats * s2, Stats * s3 )
{
	for ( int i = 0; i < s1->index; i++ )
		fprintf(file,"%f,%f,%f\n",s1->array[i],s2->array[i],s3->array[i]);
}

void Stats::wtof(FILE * file, Stats * s1, Stats * s2, Stats * s3, Stats * s4 )
{
	for ( int i = 0; i < s1->index; i++ )
		fprintf(file,"%f,%f,%f,%f\n",s1->array[i],s2->array[i],s3->array[i],s4->array[i]);
}