// Show the motion vectors of a clip

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "TestFilter.h"
#include <math.h>
#include <stdio.h>
#include "Interpolation.h"


TestFilter::TestFilter(PClip _child, IScriptEnvironment* env) :
GenericVideoFilter(_child)
{
}

TestFilter::~TestFilter()
{

}


PVideoFrame __stdcall TestFilter::GetFrame(int n, IScriptEnvironment* env)
{
   PVideoFrame src = child->GetFrame(n, env);
   PVideoFrame dst = env->NewVideoFrame(vi);

   HorizontalBilin_iSSE(dst->GetWritePtr(PLANAR_Y), src->GetReadPtr(PLANAR_Y), 
      dst->GetPitch(PLANAR_Y), src->GetPitch(PLANAR_Y), dst->GetRowSize(PLANAR_Y),
      dst->GetHeight(PLANAR_Y));

   OutputDebugString("lalala\n");

   return dst;
}