// Define the BlockData class

// I borrowed a lot of code from XviD's sources here, so I thank all the developpers
// of this wonderful codec

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __WBLOCKDATA__
#define __WBLOCKDATA__

#include "portability.h"
#include "SADFunctions.h"

class WriteBlockData {

	friend class WritePlaneOfBlocks;

	int x;
	int y;
	int max_dx;
	int max_dy;
	int min_dx;
	int min_dy;

	unsigned int offset;
	int width;
	int height;
	int blockWidth;
	int blockHeight;

	WriteBlockData **neighbours;
	int neighboursCount;
	int pelRefiningOrder;
	int differenceFromNeighbours;

	VECTOR finalVector;
	unsigned int finalSAD;
	unsigned int finalVectorLength;

	SADFunction *SAD;

	/*! \brief Computes the quadratic difference between two vectors.
	 *	\param v1 First vector.
	 *	\param v2 Second vector.
	 */
	___INLINE___ static unsigned int SquareDifferenceNorm(const VECTOR& v1, const VECTOR& v2) 
	{ return (v1.x - v2.x) * (v1.x - v2.x) + (v1.y - v2.y) * (v1.y - v2.y); }

	___INLINE___ static unsigned int SquareLength(const VECTOR& v)
	{ return v.x * v.x + v.y * v.y; }

public : 

	/*! \brief Constructor of the class.
	 *	\param x_pos X coordinate of the first pixel of the block.
	 *	\param y_pos Y coordinate of the first pixel of the block.
	 *	\param w Width of the frame.
	 *	\param h Height of the frame.
	 *	\param bw Width of the block.
	 *	\param bh Height of the block.
	 *	\param pro Precision of the interpolation.
	 */
	WriteBlockData(int x_pos, int y_pos, int w, int h, int bw, int bh, int pro);

	~WriteBlockData();

	/*! \brief Compute the sum of the square difference of the motion vector from the 
	 *  motion vectors of the surrounding blocks.
	 */
	void ComputeDifferenceFromNeighbours();
	void ComputeSAD();
	void FetchVectorFromFile(MVFileHandler *input, int predx, int predy);

	// No need to comment these ones.

	___INLINE___ unsigned int GetX() const { return x; }
	___INLINE___ unsigned int GetY() const { return y; }
	___INLINE___ unsigned int GetDifferenceFromNeighbours() const { return differenceFromNeighbours; }
	___INLINE___ VECTOR GetFinalMV() const { return finalVector; }
	___INLINE___ unsigned int GetFinalMVLength() const { return finalVectorLength; }
	___INLINE___ unsigned int GetFinalSAD() const { return finalSAD;}
};

#endif