#include "WriteGroupOfPlanes.h"

WriteGroupOfPlanes::WriteGroupOfPlanes(int w, int h, int bw, int bh, int lv, int pel, bool isb)
{
	width = w;
	height = h;
	blockWidth = bw;
	blockHeight = bh;
	levelCount = lv;
	pelAccuracy = pel;
	isBackward = isb

	planes = new WritePlaneOfBlocks*[levelCount];
	int ratio = 1;
	for ( int i = 0; i < levelCount; i++ )
	{
		planes[i] = new PlaneOfBlocks(width / ratio, height / ratio, blockWidth, blockHeight, (i == 0) ? pelAccuracy : 1, i);
		ratio *= 2;
	}
}

WriteGroupOfPlanes::WriteGroupOfPlanes(MVFileHandler *input)
{
}

WriteGroupOfPlanes::~WriteGroupOfPlanes()
{
	for ( int i = 0; i < levelCount; i++ )
		delete planes[i];
	delete[] planes;
}

void WriteGroupOfPlanes::FetchGroupFromFile(MVFileHandler *input)
{

}

void WriteGroupOfPlanes::WriteToArray(int *array)
{
	array[0] = width;
	array[1] = height;
	array[2] = blockWidth;
	array[3] = blockHeight;
	array[4] = levelCount;
	array[5] = pelAccuracy;
	array[6] = 1;
	array[7] = ( isBackward ) ? 1 : 0;

	array += headerSize;
	for (int i = 0; i < levelCount; i++ )
	{
		array[0] = planes[i]->GetArraySize();
		planes[i]->WriteToArray(array + 1);
		array += planes[i]->GetArraySize() + 1;
	}
}

void WriteGroupOfPlanes::WriteDefaultToArray(int *array)
{
	array[0] = width;
	array[1] = height;
	array[2] = blockWidth;
	array[3] = blockHeight;
	array[4] = levelCount;
	array[5] = pelAccuracy;
	array[6] = 0;
	array[7] = ( isBackward ) ? 1 : 0;

	array += headerSize;
	for (int i = 0; i < levelCount; i++ )
	{
		array[0] = planes[i]->GetArraySize();
		planes[i]->WriteDefaultToArray(array + 1);
		array += planes[i]->GetArraySize() + 1;
	}
}

int WriteGroupOfPlanes::GetArraySize()
{
	int size = headerSize;
	for ( int i = 0; i < levelCount; i++ )
		size += planes[i]->GetArraySize() + 1;

	return size;

}