// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __WGOPLANES__
#define __WGOPLANES__

#include "WritePlaneOfBlocks.h"

class WriteGroupOfPlanes {
	int width;
	int height;
	int blockWidth;
	int blockHeight;
	int levelCount;
	int pelAccuracy;
	bool isBackward;
	WritePlaneOfBlocks **planes;

	static const int headerSize = 8;

public :
	WriteGroupOfPlanes(int w, int h, int bw, int bh, int lv, int pel, bool isb);
	WriteGroupOfPlanes(MVFileHandler *input);

	~WriteGroupOfPlanes();

	void FetchGroupFromFile(MVFileHandler *input);

	void WriteToArray(int *array, bool isb);
	void WriteDefaultToArray(int *array, bool isb);
	int GetArraySize();
};

#endif