#include "WritePlaneOfBlocks.h"


WritePlaneOfBlocks::WritePlaneOfBlocks(int w, int h, int bw, int bh, int pa, int lv)
{
	pelAccuracy = pa;
	accuracyLevel = ilog2(pa);
	pelAccuracy = pa;

	blockWidth = bw;
	blockHeight = bh;

	width = w;
	height = h;

	reducedWidth = width / blockWidth;
	reducedHeight = height / blockHeight;
	blocksCount = reducedHeight * reducedWidth;

	scaleLevel = lv;
	effectiveScale = iexp2(lv);

	blocks = new WriteBlockData*[blocksCount];

	for ( int j = 0; j < reducedHeight; j++ )
	{
		for ( int i = 0; i < reducedWidth; i++ )
		{
			int index = i + j * reducedWidth;
			blocks[index] = new BlockData(i * blockWidth, j * blockHeight, width, height,
										  blockWidth, blockHeight, pelAccuracy);
		}
	}

	SetNeighbours();
}

WritePlaneOfBlocks::~WritePlaneOfBlocks()
{
}

void WritePlaneOfBlocks::SetNeighbours()
{
	int i, j;

	// First, we set the neighbours of the fours corners
		
	// Top left corner
	blocks[0]->neighboursCount = 3;
	blocks[0]->neighbours = new BlockData*[3];
	blocks[0]->neighbours[0] = blocks[1];
	blocks[0]->neighbours[1] = blocks[reducedWidth];
	blocks[0]->neighbours[2] = blocks[reducedWidth + 1];

	// Top right corner
	blocks[reducedWidth - 1]->neighboursCount = 3;
	blocks[reducedWidth - 1]->neighbours = new BlockData*[3];
	blocks[reducedWidth - 1]->neighbours[0] = blocks[reducedWidth - 2];
	blocks[reducedWidth - 1]->neighbours[1] = blocks[2 * reducedWidth - 2];
	blocks[reducedWidth - 1]->neighbours[2] = blocks[2 * reducedWidth - 1];

	// Bottom left corner
	blocks[blocksCount - reducedWidth]->neighboursCount = 3;
	blocks[blocksCount - reducedWidth]->neighbours = new BlockData*[3];
	blocks[blocksCount - reducedWidth]->neighbours[0] = blocks[reducedWidth * (reducedHeight - 2)];
	blocks[blocksCount - reducedWidth]->neighbours[1] = blocks[reducedWidth * (reducedHeight - 2) + 1];
	blocks[blocksCount - reducedWidth]->neighbours[2] = blocks[reducedWidth * (reducedHeight - 1) + 1];

	// Bottom right corner
	blocks[blocksCount - 1]->neighboursCount = 3;
	blocks[blocksCount - 1]->neighbours = new BlockData*[3];
	blocks[blocksCount - 1]->neighbours[0] = blocks[blocksCount - reducedWidth - 2];
	blocks[blocksCount - 1]->neighbours[1] = blocks[blocksCount - reducedWidth - 1];
	blocks[blocksCount - 1]->neighbours[2] = blocks[blocksCount - 2];

	// Then, we do the four edges

	// Top edge
	for ( i = 1; i < reducedWidth - 1; i++ )
	{
		blocks[i]->neighboursCount = 5;
		blocks[i]->neighbours = new BlockData*[5];
		blocks[i]->neighbours[0] = blocks[i - 1];
		blocks[i]->neighbours[1] = blocks[i + 1];
		blocks[i]->neighbours[2] = blocks[i + reducedWidth - 1];
		blocks[i]->neighbours[3] = blocks[i + reducedWidth];
		blocks[i]->neighbours[4] = blocks[i + reducedWidth + 1];
	}

	// Bottom edge
	for ( i = blocksCount - reducedWidth + 1; i < blocksCount - 1; i++ )
	{
		blocks[i]->neighboursCount = 5;
		blocks[i]->neighbours = new BlockData*[5];
		blocks[i]->neighbours[0] = blocks[i - reducedWidth - 1];
		blocks[i]->neighbours[1] = blocks[i - reducedWidth];
		blocks[i]->neighbours[2] = blocks[i - reducedWidth + 1];
		blocks[i]->neighbours[3] = blocks[i - 1];
		blocks[i]->neighbours[4] = blocks[i + 1];
	}

	// Left edge
	for ( i = reducedWidth; i < blocksCount - reducedWidth; i+=reducedWidth )
	{
		blocks[i]->neighboursCount = 5;
		blocks[i]->neighbours = new BlockData*[5];
		blocks[i]->neighbours[0] = blocks[i - reducedWidth];
		blocks[i]->neighbours[1] = blocks[i - reducedWidth + 1];
		blocks[i]->neighbours[2] = blocks[i + 1];
		blocks[i]->neighbours[3] = blocks[i + reducedWidth];
		blocks[i]->neighbours[4] = blocks[i + reducedWidth + 1];
	}

	// Right edge
	for ( i = 2 * reducedWidth - 1; i < blocksCount - reducedWidth; i+=reducedWidth )
	{
		blocks[i]->neighboursCount = 5;
		blocks[i]->neighbours = new BlockData*[5];
		blocks[i]->neighbours[0] = blocks[i - reducedWidth - 1];
		blocks[i]->neighbours[1] = blocks[i - reducedWidth];
		blocks[i]->neighbours[2] = blocks[i - 1];
		blocks[i]->neighbours[3] = blocks[i + reducedWidth - 1];
		blocks[i]->neighbours[4] = blocks[i + reducedWidth];
	}

	// Finally, we do the center of the frame
	for ( j = 1; j < reducedHeight - 1; j++ )
	{
		for ( i = 1; i < reducedWidth - 1; i++ )
		{
			int index = j * reducedWidth + i;
			blocks[index]->neighboursCount = 8;
			blocks[index]->neighbours = new BlockData*[8];
			blocks[index]->neighbours[0] = blocks[index - reducedWidth - 1];
			blocks[index]->neighbours[1] = blocks[index - reducedWidth];
			blocks[index]->neighbours[2] = blocks[index - reducedWidth + 1];
			blocks[index]->neighbours[3] = blocks[index - 1];
			blocks[index]->neighbours[4] = blocks[index + 1];
			blocks[index]->neighbours[5] = blocks[index + reducedWidth - 1];
			blocks[index]->neighbours[6] = blocks[index + reducedWidth];
			blocks[index]->neighbours[7] = blocks[index + reducedWidth + 1];
		}
	}
}

void WritePlaneOfBlocks::FetchPlaneFromFile(MVFileHandler *input)
{
}


void WritePlaneOfBlocks::WriteToArray(int *array)
{
	array[0] = width;
	array[1] = height;
	array[2] = reducedWidth;
	array[3] = reducedHeight;
	array[4] = blockWidth;
	array[5] = blockHeight;
	array[6] = blocksCount;
	array[7] = pelAccuracy;

	int pos = headerSize;
	for ( int i = 0; i < blocksCount; i++ )
	{
		array[pos] = blocks[i]->GetFinalSAD();
		array[pos + 1] = blocks[i]->GetFinalMV().x;
		array[pos + 2] = blocks[i]->GetFinalMV().y;
		array[pos + 3] = blocks[i]->GetDifferenceFromNeighbours();
		pos += 4;
	}
}

void WritePlaneOfBlocks::WriteDefaultToArray(int *array)
{
	array[0] = width;
	array[1] = height;
	array[2] = reducedWidth;
	array[3] = reducedHeight;
	array[4] = blockWidth;
	array[5] = blockHeight;
	array[6] = blocksCount;
	array[7] = pelAccuracy;

	int pos = headerSize;
	for ( int i = 0; i < blocksCount; i++ )
	{
		array[pos] = 0;
		array[pos + 1] = 0;
		array[pos + 2] = 0;
		array[pos + 3] = 0;
		pos += 4;
	}
}

int WritePlaneOfBlocks::GetArraySize()
{
	int size = 0;
	size += headerSize;
	size += blocksCount * 4;
	return size;
}

