// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __WPOBLOCKS__
#define __WPOBLOCKS__

#include "portability.h"
#include "commonfunctions.h"
#include "WriteBlockData.h"

class WritePlaneOfBlocks {
    
	int width;
	int height;
	int reducedWidth;
	int reducedHeight;
	int blockWidth;
	int blockHeight;
	int blocksCount;
	int pelAccuracy;
	int accuracyLevel;
	int scaleLevel;
	int effectiveScale;

	static const int headerSize = 8;

	WriteBlockData **blocks;

	void SetNeighbours();

public :

	WritePlaneOfBlocks(int w, int h, int bw, int bh, int pa, int lv);
	~WritePlaneOfBlocks();

	void FetchPlaneFromFile(MVFileHandler *input);

	void WriteToArray(int *array);
	void WriteDefaultToArray(int *array);
	int GetArraySize();
};

#endif
