// Show the motion vectors of a clip

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "YUVSource.h"
#include "MVInterface.h"

YUVSource::YUVSource(const char *pFileName, int nWidth, int nHeight, IScriptEnvironment* env)
{
   pFile = fopen(pFileName, "rb");

   if ( !pFile ) 
      env->ThrowError("YUVSource : could not open the file");

   vi.width = nWidth;
   vi.height = nHeight;
   vi.fps_numerator = 25;
   vi.fps_denominator = 1;
   vi.pixel_type = VideoInfo::CS_YV12;
   vi.audio_samples_per_second = 0;

   nFrameSize = vi.width * vi.height * 3 / 2;

   int size;
   fseek(pFile, 0, SEEK_END);
   size = ftell(pFile);

   vi.num_frames = size / nFrameSize;

   DebugPrintf("nFrameSize : %i, nFrames : %i", nFrameSize, vi.num_frames);
}

YUVSource::~YUVSource()
{
   if (pFile)
      fclose(pFile);

}


PVideoFrame __stdcall YUVSource::GetFrame(int n, IScriptEnvironment* env)
{
   PVideoFrame dst = env->NewVideoFrame(vi);
   unsigned char *pDst;
   int nPitch;

   // seek to the beginning of the current frame
   int a = fseek(pFile, nFrameSize * n, SEEK_SET);

   if (!a) DebugPrintf("%i", ftell(pFile));

   // fetch the Y plane
   pDst = YWPLAN(dst);
   nPitch = YPITCH(dst);

   for ( int i = 0; i < vi.height; i++ )
   {
      fread(pDst, 1, vi.width, pFile);
      pDst += nPitch;
   }

   // fetch the U plane
   pDst = UWPLAN(dst);
   nPitch = UPITCH(dst);
   for ( int i = 0; i < vi.height / 2; i++, pDst += nPitch )
      fread(pDst, 1, vi.width / 2, pFile);

   // fetch the V plane
   pDst = VWPLAN(dst);
   nPitch = VPITCH(dst);
   for ( int i = 0; i < vi.height / 2; i++, pDst += nPitch )
      fread(pDst, 1, vi.width / 2, pFile);
   
   return dst;
}